package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceApplySettlementDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceApplySettlementSearchParam;
import java.util.List;

/**
 * 发票申请与结算单关系表
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteInvoiceApplySettlementService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 发票申请与结算单关系集合
     */
    List<InvoiceApplySettlementDto> selectPage(InvoiceApplySettlementSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InvoiceApplySettlementSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 发票申请与结算单关系
     */
    InvoiceApplySettlementDto selectById(Long id);

    /**
     * 新增
     * @param dto 发票申请与结算单关系
     * @return 执行结果
     */
    int insert(InvoiceApplySettlementDto dto);

    /**
     * 更新
     * @param dto 发票申请与结算单关系
     * @return 影响行数
     */
    int update(InvoiceApplySettlementDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}