package cn.com.duiba.quanyi.center.api.remoteservice.project;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.project.ProjectAuthDto;
import cn.com.duiba.quanyi.center.api.param.project.ProjectAuthSearchParam;

import java.util.List;

/**
 * 项目权限
 *
 * @author kjj mybatis generator
 * @date 2024-10-21
 */
@AdvancedFeignClient
public interface RemoteProjectAuthService {

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<ProjectAuthDto> selectPage(ProjectAuthSearchParam param);

    /**
     * 不分页查询
     *
     * @param param
     * @return
     */
    List<ProjectAuthDto> selectNoPage(ProjectAuthSearchParam param);

    /**
     * 查询总数
     *
     * @param param
     * @return
     */
    long selectCount(ProjectAuthSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id
     * @return
     */
    ProjectAuthDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    long insert(ProjectAuthDto dto);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    int update(ProjectAuthDto dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    int delete(Long id);
}