package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.AlipayMchConsumeStatisticDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.AlipayMchConsumeStatisticSearchParam;

import java.util.Date;
import java.util.List;

/**
 * 支付宝商户号消耗
 * @author kjj mybatis generator 
 * @date 2025-01-13
 */
@AdvancedFeignClient
public interface RemoteAlipayMchConsumeStatisticService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝商户号消耗集合
     */
    List<AlipayMchConsumeStatisticDto> selectPage(AlipayMchConsumeStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AlipayMchConsumeStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝商户号消耗
     */
    AlipayMchConsumeStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝商户号消耗
     * @return 执行结果
     */
    int insert(AlipayMchConsumeStatisticDto dto);

    /**
     * 更新
     * @param dto 支付宝商户号消耗
     * @return 影响行数
     */
    int update(AlipayMchConsumeStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据时间查询，统计商户号平均消费金额
     * @param startDate
     * @param endDate
     * @param mchIds
     * @return
     */
    List<AlipayMchConsumeStatisticDto> selectByCurDateAndMchId(Date startDate, Date endDate, List<String> mchIds);
}