package cn.com.duiba.quanyi.center.api.remoteservice.settlement.prepayment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.prepayment.PrepaymentDeductionDto;

import java.util.List;

/**
 * 预付款抵扣
 * @author kjj mybatis generator 
 * @date 2025-03-05
 */
@AdvancedFeignClient
public interface RemotePrepaymentDeductionService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 预付款抵扣
     */
    PrepaymentDeductionDto selectById(Long id);

    /**
     * 根据开票申请ID查询
     * @param invoiceApplyId 开票申请ID
     * @return 预付款抵扣
     */
    List<PrepaymentDeductionDto> selectByInvoiceApplyId(Long invoiceApplyId);

    /**
     * 根据预付款ID查询
     * @param prepaymentId 预付款ID
     * @param deductionStatus 抵扣状态, 0-已撤销，1-已抵扣
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     * @return 预付款抵扣
     */
    List<PrepaymentDeductionDto> selectByPrepaymentId(Long prepaymentId, Integer deductionStatus);
}