package cn.com.duiba.quanyi.center.api.remoteservice.settlement.receive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.receive.ReceivedPaymentRecordDto;

/**
 * 回款关联或取消关联记录
 * @author kjj mybatis generator 
 * @date 2024-12-11
 */
@AdvancedFeignClient
public interface RemoteReceivedPaymentRecordService {

    /**
     * 查询回款最后一次记录
     * @param receiveId 回款ID
     * @return 回款关联或取消关联记录
     */
    ReceivedPaymentRecordDto selectLastByReceiveId(Long receiveId);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 回款关联或取消关联记录
     */
    ReceivedPaymentRecordDto selectById(Long id);
}