package cn.com.duiba.quanyi.center.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.wx.WxBillTypeStockDto;
import cn.com.duiba.quanyi.center.api.param.wx.WxBillTypeStockSearchParam;

import java.util.List;

/**
 * 微信核销数据统计表
 * @author kjj mybatis generator 
 * @date 2024-06-27
 */
@AdvancedFeignClient
public interface RemoteWxBillTypeStockService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 微信核销数据统计集合
     */
    List<WxBillTypeStockDto> selectPage(WxBillTypeStockSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxBillTypeStockSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信核销数据统计
     */
    WxBillTypeStockDto selectById(Long id);

    /**
     * 根据stockId查询
     * @param stockIds stockId集合
     * @return 微信核销数据统计集合
     */
    List<WxBillTypeStockDto> selectByStockIds(List<String> stockIds);

    /**
     * 新增
     * @param dto 微信核销数据统计
     * @return 执行结果
     */
    int insert(WxBillTypeStockDto dto);

    /**
     * 更新
     * @param dto 微信核销数据统计
     * @return 影响行数
     */
    int update(WxBillTypeStockDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}