package cn.com.duiba.quanyi.center.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.wx.WxCouponStatisticDto;
import cn.com.duiba.quanyi.center.api.dto.wx.WxWriteOffDataStatisticDto;
import cn.com.duiba.quanyi.center.api.param.wx.WxWriteOffDataStatisticSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 微信核销数据统计表
 * @author kjj mybatis generator 
 * @date 2024-06-19
 */
@AdvancedFeignClient
public interface RemoteWxWriteOffDataStatisticService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 微信核销数据统计集合
     */
    Pair<Long, List<WxCouponStatisticDto>> selectPage(WxWriteOffDataStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(WxWriteOffDataStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 微信核销数据统计
     */
    WxWriteOffDataStatisticDto selectById(Long id);

    /**
     * 新增
     * @param dto 微信核销数据统计
     * @return 执行结果
     */
    int insert(WxWriteOffDataStatisticDto dto);

    /**
     * 更新
     * @param dto 微信核销数据统计
     * @return 影响行数
     */
    int update(WxWriteOffDataStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据批次号ID批量查询统计类型是截止到当前时间的统计数据
     *
     * @param stockIdList 批次号ID
     * @return 结果
     */
    List<WxWriteOffDataStatisticDto> selectByStockIdsAndStatisticTypeAll(List<String> stockIdList);
}