package cn.com.duiba.quanyi.center.api.dto.insurance.equity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 保司权益表
 * @author mybatis generator 
 * @date 2024-03-04
 */
@Data
public class InsuranceEquityCdtbDto implements Serializable {
     
    private static final long serialVersionUID = 17095322687013054L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 保险公司ID，tb_insurance_company.id
     */
    private Long companyId;

    /**
     * 机构ID，tb_insurance_institution.id
     */
    private Long institutionId;

    /**
     * 坐席手机号
     */
    private String salesmanPhone;

    /**
     * 坐席姓名
     */
    private String salesmanName;

    /**
     * 坐席登录账号ID
     */
    private Long salesmanId;

    /**
     * 兑换状态：1-为兑换，2-部分兑换，3-已兑换
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceEquityStatusEnum
     */
    private Integer takeStatus;

    /**
     * 总金额，单位分
     */
    private Long totalAmount;

    /**
     * 已发放金额，单位分
     */
    private Long grantAmount;

    /**
     * 代领人姓名
     */
    private String takeProxyName;

    /**
     * 代领人手机号
     */
    private String takeProxyPhone;

    /**
     * 文本备注
     */
    private String textRemark;

    /**
     * 图片备注，图片地址以英文逗号分隔
     */
    private String picRemark;

    /**
     * 实际发放账户手机号
     */
    private String accountPhone;

    /**
     * 第一次发放时间
     */
    private Date firstGrantTime;

}