package cn.com.duiba.quanyi.center.api.enums.bill;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * SxghBillTradeTypeEnum
 *
 * @author fmk
 * @since 2024/4/28
 */
@Getter
@RequiredArgsConstructor
public enum SxghBillTradeTypeEnum {

    /**
     * 支付
     */
    PAY(10, "支付"),

    /**
     * 退款
     */
    REFUND(20, "退款");

    private final Integer code;

    private final String desc;

    public static SxghBillTradeTypeEnum getByDesc(String desc) {
        for (SxghBillTradeTypeEnum typeEnum : values()) {
            if (typeEnum.getDesc().equals(desc)) {
                return typeEnum;
            }
        }
        return null;
    }


}
