package cn.com.duiba.quanyi.center.api.param.order;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 订单表
 * @author kjj mybatis generator
 * @date 2023-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class GoodsOrderPageParam extends PageQuery {

    private static final long serialVersionUID = 451413620410156479L;


    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 订单号
     */
    private String goodsOrderNo;

    /**
     * 规格ID
     */
    private Long skuId;

    /**
     * 客户id
     */
    private Long goodsBizId;

    /**
     * 订单状态, 1-处理中，2-成功，3-失败, 4-异常
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 商品类型为微信时的充值账号
     */
    private String openId;

    /**
     * 商品类型为支付宝时的 支付宝用户id
     */
    private String alipayUserId;

    /**
     * 商品类型为支付宝时的 支付宝手机号
     */
    private String phoneId;

    /**
     * 商品类型为支付宝时的 支付宝邮箱号
     */
    private String loginId;

    /**
     * 商品类型为其他直冲时的 充值账户
     */
    private String account;

    /**
     * 链接券类型时的短链
     */
    private String shortUrl;

}