package cn.com.duiba.quanyi.center.api.remoteservice.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.common.UploadTaskExtDto;

import java.util.List;

/**
 * 上传任务拓展表
 * @author kjj mybatis generator 
 * @date 2025-05-13
 */
@AdvancedFeignClient
public interface RemoteUploadTaskExtService {

    /**
     * 筛选有效期时间范围
     * @return
     */
    List<UploadTaskExtDto> selectEffectiveDate(Long bizId, Integer bizType);

    /**
     * 新增
     * @param dto 上传任务拓展
     * @return 执行结果
     */
    int save(UploadTaskExtDto dto);

    /*
     * 保存/更新任务扩展信息
     * @param dto 扩展信息
     * @return 成功条数
     */
    int saveOrUpdate(UploadTaskExtDto dto);

    /**
     * 根据任务id查询扩展信息
     * @param taskIdList 任务id列表
     * @return 扩展信息map
     */
    List<UploadTaskExtDto> selectByTaskIds(List<Long> taskIdList);

    /**
     * 根据任务id查询
     * @param taskId 任务id
     * @return 扩展信息
     */
    UploadTaskExtDto selectByTaskId(Long taskId);
}