package cn.com.duiba.quanyi.center.api.remoteservice.project;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.project.ProjectGrossMarginRecordDto;
import cn.com.duiba.quanyi.center.api.param.project.ProjectGrossMarginRecordSearchParam;
import java.util.List;

/**
 * 项目品类毛利率记录表
 * @author kjj mybatis generator
 * @date 2025-05-20
 */
@AdvancedFeignClient
public interface RemoteProjectGrossMarginRecordService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 项目品类毛利率记录集合
     */
    List<ProjectGrossMarginRecordDto> selectPage(ProjectGrossMarginRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ProjectGrossMarginRecordSearchParam param);

    /**
     * 批量插入或更新
     * @param list 数据集合
     * @return 影响行数
     */
    int batchInsertOrUpdate(List<ProjectGrossMarginRecordDto> list);
}
