package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.PuFaBillDto;
import cn.com.duiba.quanyi.center.api.param.qystatistic.PuFaBillSearchParam;
import java.util.List;

/**
 * 浦发账单表
 * @author kjj mybatis generator 
 * @date 2025-05-07
 */
@AdvancedFeignClient
public interface RemotePuFaBillService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 浦发账单集合
     */
    List<PuFaBillDto> selectPage(PuFaBillSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(PuFaBillSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 浦发账单
     */
    PuFaBillDto selectById(Long id);

    /**
     * 新增
     * @param dto 浦发账单
     * @return 执行结果
     */
    int insert(PuFaBillDto dto);

    /**
     * 更新
     * @param dto 浦发账单
     * @return 影响行数
     */
    int update(PuFaBillDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}