package cn.com.duiba.quanyi.center.api.dto.activity.common.cache;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 活动黑白名单表
 * @author mybatis generator
 * @date 2025-04-15
 */
@Data
public class ActivityBlackWhiteListCacheDto implements Serializable {

    private static final long serialVersionUID = 17446989970564755L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 类型：1-白名单，2-黑名单
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityBlackWhiteListTypeEnum
     */
    private Integer listType;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期结束时间
     */
    private Date endTime;

    /**
     * 达标金额
     */
    private Long reachStandardAmount;

    /**
     * 发放金额
     */
    private Long grantAmount;

    /**
     * 是否限制领取数量
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer limitNum;

    /**
     * 总数量
     */
    private Long totalNum;

    /**
     * 已使用数量
     */
    private Long usedNum;

    /**
     * 用户ID_领取时间戳,用户ID_领取时间戳
     */
    private String takeInfo;
}
