package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动奖品定时任务规则
 * 1-替换，2-新增，3-删除
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum ActivityPrizeScheduledTaskBizRule {

    REPLACE(1, "替换"),
    ADD(2, "新增"),
    DELETE(3, "删除"),
    ;


    private final Integer type;

    private final String desc;


    public static ActivityPrizeScheduledTaskBizRule getByType(Integer type) {
        for (ActivityPrizeScheduledTaskBizRule value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
