package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动奖品定时任务类型
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum ActivityPrizeScheduledTaskBizType {

    STOCK_UPDATE(1, "库存更新"),
    ;


    private final Integer type;

    private final String desc;


    public static ActivityPrizeScheduledTaskBizType getByType(Integer type) {
        for (ActivityPrizeScheduledTaskBizType value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
