package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeScheduledTaskDto;
import cn.com.duiba.quanyi.center.api.param.activity.ActivityPrizeScheduledTaskSearchParam;
import java.util.List;

/**
 * 活动奖品定时任务表
 * @author kjj mybatis generator 
 * @date 2025-05-27
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeScheduledTaskService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动奖品定时任务集合
     */
    List<ActivityPrizeScheduledTaskDto> selectPage(ActivityPrizeScheduledTaskSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityPrizeScheduledTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动奖品定时任务
     */
    ActivityPrizeScheduledTaskDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动奖品定时任务
     * @return 执行结果
     */
    int insert(ActivityPrizeScheduledTaskDto dto);

    /**
     * 更新
     * @param dto 活动奖品定时任务
     * @return 影响行数
     */
    int update(ActivityPrizeScheduledTaskDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}