/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.pay;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PayChannelTypeEnum {
    WX_LITE("wx_lite", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8"),
    CCB_PAY("ccb_pay", "\u5efa\u8bbe\u94f6\u884c\u6570\u5b57\u8d27\u5e01H5"),
    ALIPAY_WAP_PAY("alipay_wap_pay", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed82.0"),
    ALIPAY_WAP_PAY_FACE("alipay_ftf_jsapi", "\u652f\u4ed8\u5b9d\u5f53\u9762\u4ed8"),
    INSURANCE_FUND("insurance_fund", "\u4fdd\u53f8\u8d26\u6237\u4f59\u989d"),
    HZ_BANK_PAY("hz_bank_pay", "\u676d\u5dde\u94f6\u884c\u652f\u4ed8"),
    MINSHENG_PAY("minsheng_pay", "\u5168\u6c11\u751f\u6d3bAPP\u6536\u94f6\u53f0"),
    WX_PUB("wx_pub", "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8"),
    PSBC_PAY("psbc_pay", "\u90ae\u50a8\u94f6\u884c\u652f\u4ed8"),
    CGB_PAY("cgb_pay", "\u5e7f\u53d1\u94f6\u884capp\u652f\u4ed8"),
    BOC_PAY("boc_pay", "\u4e2d\u884c\u652f\u4ed8"),
    CREDITS_EXCHANGE_MALL("credits_exchange_mall", "\u79ef\u5206\u5151\u6362"),
    TRUSTEESHIP_CREDITS_FUND("trusteeship_credits_fund", "\u6258\u7ba1\u79ef\u5206\u8d26\u6237\u5151\u6362");

    private final String channelType;
    private final String channelName;
    private static final List<String> NOT_NEED_REFUND;
    private static final Map<String, PayChannelTypeEnum> ENUM_MAP;

    public static PayChannelTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static List<String> getNeedRefundList() {
        return NOT_NEED_REFUND;
    }

    private PayChannelTypeEnum(String channelType, String channelName) {
        this.channelType = channelType;
        this.channelName = channelName;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    static {
        NOT_NEED_REFUND = Collections.unmodifiableList(Arrays.asList(CGB_PAY.getChannelType(), CCB_PAY.getChannelType(), MINSHENG_PAY.getChannelType(), HZ_BANK_PAY.getChannelType()));
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(PayChannelTypeEnum.values()).collect(Collectors.toMap(PayChannelTypeEnum::getChannelType, Function.identity(), (v1, v2) -> v2)));
    }
}

