package cn.com.duiba.quanyi.center.api.enums.inner;

/**
 * inner日志type枚举
 *
 * @author zzy
 * @create 2023/12/14 15:43
 **/
public enum InnerLogTypeEnum {
    API_CREATE_ORDER(1, "API供货CreateOrder"),
    API_QUERY_ORDER(2, "API供货QueryOrder"),
    CCB_CANCLE_ORDER(3, "建总行作废订单Cancle"),
    CCB_PUSH_ORDER(4, "建行订单推送记录"),
    PUFA_PUSH_ORDER(5, "浦发订单推送记录"),
    SUPPLY_PUSH_ORDER(6, "通用订单推送记录"),
    JS_BANK_PUSH_ORDER(7, "江苏银行订单推送记录"),
    JILIN_BANK_V2_PUSH_ORDER(8, "吉林银行V2推送记录"),
    API_SIGNING(9, "API用户签约Signing"),
    ABC_BANK_PUSH_ORDER(10, "农行核销订单推送记录"),
    API_QUERY_ALIPAY_ACCOUNT(11, "API供货queryAlipayAccount"),
    API_ACTIVITY_LOGIN(12, "API供给活动登录"),
    API_ACTIVITY_LOGIN_RESULT(13, "API供给活动登录结果"),
    API_CALL_THIRD(14, "API供给调用客户接口"),
    API_ACTIVITY_TAKE(15, "API供给活动领取"),
    API_ACTIVITY_TAKE_RESULT(16, "API供给活动领取结果"),
    API_ACTIVITY_SUBMIT(17, "API供给活动输入账号"),
    API_ACTIVITY_RESULT(18, "API供给活动发放结果"),
    API_SUPPLY_CREATE_ORDER(19, "API供货下单"),
    API_SUPPLY_QUERY_ORDER(20, "API供货查询订单"),
    API_SUPPLY_NOTIFY_ORDER(21, "API供货订单状态通知"),
    API_SUPPLY_COMMON(22, "API供货标准接口"),
    MS_SUPPLY_PUSH(24, "民生协调推送"),
    PSBC_PUSH_ORDER(25, "邮储银行推送记录"),

    API_MULTI_CREATE_ORDER(26, "API多选一供货CreateOrder"),
    API_MULTI_QUERY_ORDER(27, "API多选一供货QueryOrder"),
    PSBC_COUPON_ISSUE_NOTICE(28, "邮储发券通知"),
    CQTB_LOG(29, "重庆太保定制日志"),
    CQTB_NOTIFY_LOG(30, "重庆太保定制推送日志"),


    ABC_REQ_LOG(51, "农行接口调用记录"),
    JD_REQ_LOG(52, "京东接口调用记录"),
    ACTIVITY_COMMON_USER_API_VERIFY(53, "通用活动-用户API校验"),
    ACTIVITY_COMMON_API_REACH_STANDARD(54, "通用活动-用户API达标校验"),
    ACTIVITY_COMMON_TAKE(55, "通用活动-领取"),
    ACTIVITY_COMMON_TAKE_RESULT(56, "通用活动-领取结果"),
    ACTIVITY_COMMON_COLLECTION_PAGE_USER_API_VERIFY(57, "通用活动-用户API校验"),
    ACTIVITY_QZ_WHITE_RESULT(58, "衢州白名单接口返回"),
    ;
    private final Integer type;

    private final String desc;

    InnerLogTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
