package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum ActivityExtEnum {

    SUPPLY_GOODS_TYPE(1, "商品类型", false),

    SUPPLY_GRANT_TYPE(2, "供给方式", false),

    SUPPLY_LINK_TYPE(3, "链接券形式(,分割)", false),

    SUPPLY_API_JOINT_ID(4, "API对接ID", false),

    ICBC_CUSTOM_ID(5, "工行-客群id(,分割)", false),

    SHORT_URL_EFFECTIVE_DAYS(6, "短链有效天数", true),

    ACTIVITY_PAGE_CONFIG(7, "活动页面配置", false),
    ACTIVITY_PRIZE_CONFIG(8, "活动奖项配置", false),
    ACTIVITY_LIMIT_CONFIG(9, "活动限制配置", false),
    ACTIVITY_BACKGROUND_COLOR(12, "活动背景颜色", true),
    ACTIVITY_AUTO_TAKE(16, "活动是否自动领取", true),
    ACTIVITY_HELP_CONFIG(10, "活动助力配置", false),
    ACTIVITY_TEMP_PUSH_CONFIG(11, "模板活动推送配置", false),
    ACTIVITY_TEMP_STANDARD_CONFIG(13, "模板活动达标配置", false),
    ACTIVITY_TEMP_BANK_SYSTEM(14, "模板活动银行体系", false),
    ACTIVITY_TEMP_WHITE_USER(15, "模板活动白名单配置", false),
    ACTIVITY_SUB_EXPRESS(16, "活动订阅物流配置", false),
    ACTIVITY_TEMP_PAY_CONFIG(17, "模板活支付配置", false),
    ACTIVITY_TEMP_ACTIVITY_TAG(18, "模板活动定制tag", false),
    ACTIVITY_TEMP_PAY_STANDARD(19, "模板活动支付达标", false),
    SUPPLY_SHORT_TRANSFER_IS_ORDER_DETAIL(20, "短链中转页-是否是订单详情页面", false),
    SINGLE_SHORT_URL_EFFECTIVE_DAYS(21, "单张券短链有效天数", false),
    CODE_22(22, "是否开启批次不可用告警", false),
    ACTIVITY_TEMP_USER_LIMIT(23, "模板活动用户身份限制", false),
    ACTIVITY_TEMP_CARD_BIN_CONFIG(24, "模板活动卡BIN配置", false),
    ACTIVITY_TEMP_USER_SIGN_UP(25, "模板活动用户报名", false),
    API_SHORT_URL_EFFECTIVE_DAYS(26, "API供货短链过期时间", false),
    ACTIVITY_TEMP_POP_CONFIG(27, "活动弹窗配置", false),
    COLLECTION_PAGE_RELATE_ACTIVITY(28, "集合页关联活动", false),
    ACTIVITY_TEMP_SHOW_USER_ACCOUNT(29, "模板活动用户信息展示", false),
    ACTIVITY_TEMP_ANNOUNCEMENT_CONFIG(30, "模板活动公告配置", false),
    ACTIVITY_TEMP_BLACK_USER(31, "模板活动黑名单配置", false),

    FILTER_NO_DRAW_PRIZE(32, "是否过滤不可领取奖励", false),
    MULTI_PAGE_RELATE_API_ACTIVITY(33, "多选一集合页关联API活动", true),
    TAKE_RESULT_BUTTON_IMG(34, "查看领取结果按钮", false),
    SKIN_TYPE(35, "皮肤类型", false),

    /**
     * @see ActivityPrizeDrawTypeEnum
     */
    PRIZE_DRAW_TYPE(36, "出奖类型-通用活动", false),
    SKIN_ID(37, "皮肤ID-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityCommonSubTypeEnum
     */
    COMMON_SUB_TYPE(38, "活动子类型-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonUserLimitConfDto
     */
    COMMON_USER_LIMIT(39, "用户限制-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTimeLimitConfDto
     */
    COMMON_TAKE_OPEN_TIME_LIMIT(40, "领奖开放时间-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonTakeLimitConfDto
     */
    COMMON_TAKE_TIMES_LIMIT(41, "领奖次数限制-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonWhiteConfDto
     */
    COMMON_WHITE_LIST(42, "白名单配置-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonBlackConfDto
     */
    COMMON_BLACK_LIST(43, "黑名单配置-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonReachStandardConfDto
     */
    COMMON_REACH_STANDARD(44, "达标配置-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonPayConfDto
     */
    COMMON_PAY_CONF(45, "支付配置-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonSignUpConfDto
     */
    COMMON_SIGN_UP(46, "报名配置-通用活动", false),
    COMMON_STORE_CONF(47, "是否开启门店配置-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonNoticeConfDto
     */
    COMMON_NOTICE_CONF(48, "公告-通用活动", false),

    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.ActivityCommonInterfaceConfDto
     */
    COMMON_INTERFACE_CONF(49, "界面配置-通用活动", false),
    IS_OPEN_VOUCHER_PACKAGE(50, "是否开启券包-通用活动", false),
    /**
     * 当本活动挂在集合页时，该值为集合页活动ID，为null或者空时，认为不是挂在集合页的活动
     */
    COMMON_COLLECTION_PAGE_ID(51, "集合页ID-通用活动", false),
    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.collection.ActivityCommonCollectionPageParticipateLimitConfDto
     */
    COMMON_COLLECTION_PAGE_PARTICIPATE_LIMIT(52, "通用集合页-活动参与限制", false),
    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.collection.ActivityCommonCollectionPageInterfaceConfDto
     */
    COMMON_COLLECTION_PAGE_INTERFACE_CONF(53, "通用集合页-界面配置", false),
    /**
     * @see cn.com.duiba.quanyi.center.api.dto.activity.common.ext.collection.ActivityCommonCollectionPageActivityConfDto
     */
    COMMON_COLLECTION_PAGE_ACTIVITY_CONF(54, "通用集合页-活动配置", false),
    /**
     * 模版活动-门店版本
     */
    ACTIVITY_STORE_VERSION(55, "模版活动-门店版本", false),

    /**
     * 活动子类型id-通用活动
     */
    COMMON_SUB_TYPE_ID(56, "活动子类型id-通用活动", false),

    ;

    private final Integer type;

    private final String desc;

    private final boolean canDelete;

    public static boolean getEnumByCanDelete(Integer type) {
        for (ActivityExtEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.isCanDelete();
            }
        }
        return false;
    }

}
