package cn.com.duiba.quanyi.center.api.enums.activity.common;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/4/28 10:13
 */
@Getter
@AllArgsConstructor
public enum ActivityCommonCollectionPageSubTypeEnum {
    TEMPLATE(1, "模板集合页", false),

    TEST_CUSTOM(999999999, "测试定制集合页", true),
    ;

    private final Integer type;

    private final String desc;

    /**
     * 是否是定制
     */
    private final boolean custom;

    /**
     * 根据type获取枚举信息
     */
    public static ActivityCommonCollectionPageSubTypeEnum getByType(Integer type) {
        return Arrays.stream(ActivityCommonCollectionPageSubTypeEnum.values())
                .filter(item -> item.getType().equals(type))
                .findFirst()
                .orElse(null);
    }

    /**
     * 查询所有定制活动
     */
    public static List<ActivityCommonCollectionPageSubTypeEnum> getCustomEnums() {
        return Arrays.stream(ActivityCommonCollectionPageSubTypeEnum.values())
                .filter(ActivityCommonCollectionPageSubTypeEnum::isCustom)
                .collect(Collectors.toList());
    }
}
