package cn.com.duiba.quanyi.center.api.param.qy.activitystockwarn;

import java.io.Serializable;

import lombok.Data;

/**
 * 活动库存告警配置UK索引查询参数
 *
 * @author yangyukang
 * @date 2024-12-19
 */
@Data
public class ActivityStockWarnConfigUniqueKeyParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动类型,1-白名单领奖,2-兑吧卡密包,7-API供货
     */
    private Integer activityType;

    /**
     * 告警类型，1-活动库存告警，2-奖品库存告警
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityStockWarnTypeEnum
     */
    private Integer warnType;

    /**
     * 奖品ID，默认值0
     */
    private Long prizeId;
} 