package cn.com.duiba.quanyi.center.api.param.channel;

import lombok.Data;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

/**
 * @author lizhi
 * @date 2023/9/19 14:03
 */
@Data
public class MpUrlSchemeGenerateParam implements Serializable {

    private static final long serialVersionUID = 9060698253797421643L;

    /**
     * 业务类型，wxAppId不为空时，以wxAppId为准
     * @see cn.com.duiba.quanyi.center.api.enums.user.OaBizTypeEnum
     */
    private Integer bizType;

    /**
     * 微信appId
     */
    private String wxAppId;

    /**
     * 小程序页面地址
     */
    private String pagePath;

    /**
     * 小程序请求参数
     */
    private String query;

    /**
     * 默认值"release"。
     * 要打开的小程序版本。正式版为"release"，体验版为"trial"，开发版为"develop"，仅在微信外打开时生效
     */
    private String envVersion = "release";

    /**
     * 过期时间 必填
     */
    private Integer timeUnitNumber;

    /**
     * 过期时间单位，必填
     */
    private TimeUnit timeUnit;
}
