/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.activity;

import cn.com.duiba.quanyi.center.api.dto.activity.CouponExpireTypeDto;
import cn.com.duiba.quanyi.center.api.enums.activity.CouponExpireTypeEnum;
import cn.com.duiba.quanyi.center.api.utils.activity.QyDateTimeUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.Objects;

public class ActivityShortUrlExpireTimeUtils {
    private ActivityShortUrlExpireTimeUtils() {
    }

    public static Date getExpireTime(Date endTime, CouponExpireTypeDto couponExpireTypeDto) {
        if (Objects.isNull(couponExpireTypeDto)) {
            return null;
        }
        if (Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.SPECIFY_DATE.getType())) {
            return couponExpireTypeDto.getExpireTime();
        }
        if (Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.REVERSE_DAYS.getType())) {
            return DateUtils.daysAddOrSub((Date)QyDateTimeUtils.getDayEndTime(endTime), (int)(-couponExpireTypeDto.getReverseDays().intValue()));
        }
        if (Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.ORDER_DAY.getType())) {
            return DateUtils.daysAddOrSub((Date)QyDateTimeUtils.getDayEndTime(new Date()), (int)(couponExpireTypeDto.getOrderDays() - 1));
        }
        if (Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.NOW_MONTH_END.getType())) {
            return QyDateTimeUtils.getCurrentMonthEndTime(new Date());
        }
        if (Objects.equals(couponExpireTypeDto.getCouponExpireType(), CouponExpireTypeEnum.NOW_WEEK_END.getType())) {
            return QyDateTimeUtils.getSundayOfThisWeek();
        }
        return null;
    }
}

