package cn.com.duiba.quanyi.center.api.dto.activity;

import cn.com.duiba.quanyi.center.api.enums.activity.BatchTakeStatusEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 批量领取结果
 *
 * @author lizhi
 * @date 2023/8/18 16:16
 */
@Data
public class BatchTakeResultDto implements Serializable {

    private static final long serialVersionUID = 2440785135308791075L;

    /**
     * 批量订单号，成功时有值
     */
    private String batchOrderNo;

    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     */
    private Integer goodsBizType;

    /**
     * 错误码
     */
    private String failCode;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 批量发放状态
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BatchTakeStatusEnum
     */
    private Integer takeStatus;

    /**
     * 商品库spu类型，根据spuType展示不同的内容（比如卡密/短链接等等）
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 发放方式
     *
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 短链接
     */
    private String batchShortUrl;
    
    public static BatchTakeResultDto buildGrantInit(String batchOrderNo, Integer goodsBizType) {
        BatchTakeResultDto dto = new BatchTakeResultDto();
        dto.setBatchOrderNo(batchOrderNo);
        dto.setGoodsBizType(goodsBizType);
        dto.setTakeStatus(BatchTakeStatusEnum.INIT.getCode());
        return dto;
    }
    
    public static BatchTakeResultDto buildGrantProcessing(String batchOrderNo, Integer goodsBizType) {
        BatchTakeResultDto dto = new BatchTakeResultDto();
        dto.setBatchOrderNo(batchOrderNo);
        dto.setGoodsBizType(goodsBizType);
        dto.setTakeStatus(BatchTakeStatusEnum.PROCESSING.getCode());
        return dto;
    }

    public static BatchTakeResultDto buildShortUrlProcessing(String batchOrderNo, Integer goodsBizType) {
        BatchTakeResultDto dto = new BatchTakeResultDto();
        dto.setBatchOrderNo(batchOrderNo);
        dto.setGoodsBizType(goodsBizType);
        dto.setTakeStatus(BatchTakeStatusEnum.SHORT_URL_PROCESSING.getCode());
        return dto;
    }
    
    public static BatchTakeResultDto buildAllFail(String failCode, String errorMsg) {
        BatchTakeResultDto dto = new BatchTakeResultDto();
        dto.setFailCode(failCode);
        dto.setErrorMsg(errorMsg);
        dto.setTakeStatus(BatchTakeStatusEnum.ALL_FAIL.getCode());
        return dto;
    }
    
    public static BatchTakeResultDto buildShortUrlAllFail(String failCode, String errorMsg) {
        BatchTakeResultDto dto = new BatchTakeResultDto();
        dto.setFailCode(failCode);
        dto.setErrorMsg(errorMsg);
        dto.setTakeStatus(BatchTakeStatusEnum.SHORT_URL_ALL_FAIL.getCode());
        return dto;
    }
}
