package cn.com.duiba.quanyi.center.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 要授权的账号类型：
 * 1 则商户点击链接后，手机端仅展示公众号；
 * 2 表示仅展示小程序；
 * 3 表示公众号和小程序都展示。
 * <p>
 * 如果为未指定，则默认小程序和公众号都展示。第三方平台开发者可以使用本字段来控制授权的账号类型。
 *
 * @author zzy
 * @create 2025/06/13 21:45
 * @see <a href="https://developers.weixin.qq.com/doc/oplatform/Third-party_Platforms/2.0/api/Before_Develop/Authorization_Process_Technical_Description.html">授权流程</a>
 **/
@Getter
@AllArgsConstructor
public enum WxOpenPlAuthTypeEnum {
    OA_ONLY(1, "仅展示公众号"),
    MP_ONLY(2, "仅展示小程序"),
    OA_AND_MP(3, "公众号和小程序都展示"),
    ;

    private final Integer type;

    private final String desc;
}
