package cn.com.duiba.quanyi.center.api.param.demand;

import cn.com.duiba.quanyi.center.api.enums.contract.BusinessGroupTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.demand.PaymentPurposeEnum;
import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 付款申请评论
 * @author mybatis generator
 * @date 2024-12-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DemandPaymentInfoSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17332135616283316L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 需求主键, tb_demand.id
     */
    private List<Long> demandIds;

    /**
     * 审批流主键
     */
    private Long workflowInstanceId;

    /**
     * 付款事由
     */
    private String paymentReason;

    /**
     * 付款金额
     */
    private Long paymentAmount;

    /**
     * 打款公司-选项ID
     */
    private Long paymentCompanyOptionsId;

    /**
     * 打款公司
     */
    private String paymentCompany;

    /**
     * 付款方式-选项ID
     */
    private Long paymentTypeOptionsId;

    /**
     * 付款方式
     */
    private String paymentType;

    /**
     * 收款账户
     */
    private String receivingAccount;

    /**
     * 收款公司
     */
    private String receivingCompany;

    /**
     * 开户行
     */
    private String openingBank;

    /**
     * 实际打款金额
     */
    private Long actualPaymentAmount;

    /**
     * 打款状态，1-待打款，2-已打款
     * @see cn.com.duiba.quanyi.center.api.enums.demand.DemandPaymentStatusEnum
     */
    private Integer paymentStatus;

    /**
     * 需求商品主键
     */
    private Long demandGoodsId;

    /**
     * 审核状态
     */
    private Integer approvalStatus;

    /**
     * 主状态,集合
     */
    private List<Integer> mainStatusList;


    /**
     * 是否可见: 0-不可见，1-可见
     */
    private Integer showStatus;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 修改时间开始
     */
    private Date gmtModifiedStart;

    /**
     * 修改时间结束
     */
    private Date gmtModifiedEnd;

    /**
     * 主键id集合
     */
    private List<Long> ids;

    /**
     * 付款类型，1-垫资打款，2-预付款退款，3-保证金
     * @see cn.com.duiba.quanyi.center.api.enums.demand.PaymentPurposeEnum
     */
    private Integer paymentPurpose = PaymentPurposeEnum.ADVANCE_PAYMENT.getType();

    /**
     * 业务组类型，1-权益，2-数字营销
     * @see cn.com.duiba.quanyi.center.api.enums.contract.BusinessGroupTypeEnum
     */
    private Integer businessGroup = BusinessGroupTypeEnum.RIGHTS.getType();
}
