/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.deposit;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DepositStatusEnum {
    INITIATING(1, "\u53d1\u8d77\u4e2d"),
    INITIATE_FAILED(2, "\u53d1\u8d77\u5931\u8d25"),
    APPROVING(3, "\u5ba1\u6279\u4e2d"),
    APPROVAL_REJECTED(4, "\u5ba1\u6838\u62d2\u7edd"),
    PENDING_REFUND(5, "\u5f85\u56de\u6b3e"),
    PARTIAL_REFUND(6, "\u90e8\u5206\u56de\u6b3e"),
    REFUNDED(7, "\u5df2\u56de\u6b3e");

    private final Integer status;
    private final String desc;
    private static final Map<Integer, DepositStatusEnum> STATUS_MAP;

    public static DepositStatusEnum getByStatus(Integer status) {
        return STATUS_MAP.get(status);
    }

    public static String getDescByStatus(Integer status) {
        DepositStatusEnum statusEnum = DepositStatusEnum.getByStatus(status);
        return statusEnum != null ? statusEnum.getDesc() : "\u672a\u77e5\u72b6\u6001";
    }

    public static boolean canDelete(Integer status) {
        return INITIATE_FAILED.getStatus().equals(status) || APPROVAL_REJECTED.getStatus().equals(status);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    private DepositStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    static {
        STATUS_MAP = Arrays.stream(DepositStatusEnum.values()).collect(Collectors.toMap(DepositStatusEnum::getStatus, Function.identity()));
    }
}

