package cn.com.duiba.quanyi.center.api.remoteservice.project;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.project.ProjectProductDto;
import cn.com.duiba.quanyi.center.api.param.project.ProjectProductSearchParam;
import java.util.List;

/**
 * 项目与标准定制产品关联关系
 * @author kjj mybatis generator 
 * @date 2025-06-11
 */
@AdvancedFeignClient
public interface RemoteProjectProductService {

    /**
     * 根据项目id筛选
     * @param projectId
     * @return
     */
    List<ProjectProductDto> selectByProjectId(Long projectId);

    /**
     * 通过条件查询
     * @param param
     * @return
     */
    List<ProjectProductDto> listAllByParam(ProjectProductSearchParam param);
}