package cn.com.duiba.quanyi.center.api.dto.settlement.receive;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 回款
 * @author mybatis generator
 * @date 2024-12-11
 */
@Data
public class ReceivedPaymentDto implements Serializable {

    private static final long serialVersionUID = 17338978956682135L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 唯一编码
     */
    private String receivedNo;

    /**
     * 回款金额
     */
    private Long receivedAmount;


    /**
     * 打款主体ID
     */
    private Long paymentSubjectId;

    /**
     * 打款主体
     */
    private String paymentSubject;

    /**
     * 收款主体
     */
    private String receivingSubject;

    /**
     * 收款银行账户
     */
    private String receivingAccount;

    /**
     * 到款日期
     */
    private Date receivedDate;

    /**
     * 到款方式
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedMethodEnum
     */
    private Integer receivedMethod;

    /**
     * 商务名称
     */
    private String commerceName;

    /**
     * 商务ssoId
     */
    private Long commerceId;

    /**
     * 导入的任务ID
     */
    private Long taskId;

    /**
     * 状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedStatusEnum
     */
    private Integer receivedStatus;

    /**
     * 错误原因
     */
    private ReceivedErrDto errJson;

    /**
     * 所属业务
     * @see cn.com.duiba.quanyi.center.api.enums.project.BelongingBusinessTypeEnum
     */
    private Integer belongingBusiness;

    /**
     * 回款备注
     */
    private String receivedRemark;

    /**
     * 回款类型
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.receive.SettlementReceivedTypeEnum
     */
    private Integer receivedType;
}
