package cn.com.duiba.quanyi.center.api.remoteservice.demand;

import cn.com.duiba.quanyi.center.api.dto.demand.DemandRefundContractAmountTaskDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandRefundContractAmountTaskSearchParam;

import java.util.List;

/**
 * 需求回退合同金额任务RemoteService
 *
 * @author xuzhigang
 * @date 2025-09-08 16:30
 */
public interface RemoteDemandRefundContractAmountTaskService {

    /**
     * 分页查询
     * @param param 查询参数
     * @return DTO对象列表
     */
    List<DemandRefundContractAmountTaskDto> selectPage(DemandRefundContractAmountTaskSearchParam param);

    /**
     * 查询总数
     * @param param 查询参数
     * @return 总数
     */
    long count(DemandRefundContractAmountTaskSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return DTO对象
     */
    DemandRefundContractAmountTaskDto selectById(Long id);

    /**
     * 根据需求ID查询
     * @param demandId 需求ID
     * @return DTO对象列表
     */
    List<DemandRefundContractAmountTaskDto> selectByDemandId(Long demandId);

    /**
     * 新增
     * @param dto DTO对象
     * @return 主键ID
     */
    Long insert(DemandRefundContractAmountTaskDto dto);

    /**
     * 更新
     * @param dto DTO对象
     * @return 影响行数
     */
    int update(DemandRefundContractAmountTaskDto dto);

    /**
     * 删除记录
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}
