package cn.com.duiba.quanyi.center.api.param.activity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 活动黑白名单批量删除参数
 * @author yangyukang
 * @date 2025-01-15
 */
@Data
public class ActivityBlackWhiteListBatchDeleteParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 类型：1-白名单，2-黑名单
     * @see cn.com.duiba.quanyi.center.api.enums.activity.common.ActivityBlackWhiteListTypeEnum
     */
    private Integer listType;

    /**
     * 用户唯一标记列表
     */
    private List<String> userMarkList;

    /**
     * 有效期开始时间
     */
    private Date startTime;

    /**
     * 有效期结束时间
     */
    private Date endTime;

    /**
     * 奖品ID列表（支持多个奖品或没有奖品的情况）
     */
    private List<Long> prizeIdList;

    /**
     * 删除名单的操作人类型，1-内部sso用户，2-合作方员工
     */
    private Integer deleteOperatorType;

    /**
     * 删除人Id，用于排查问题
     */
    private Long deleteOperatorId;

    /**
     * 删除人姓名，用于排查问题
     */
    private String deleteOperatorName;

    /**
     * 删除时间
     */
    private Date deleteTime;
} 