package cn.com.duiba.quanyi.center.api.param.activity;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 活动业务关联关系表
 * @author mybatis generator
 * @date 2025-02-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ActivityBizRelationSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 17394180291014785L;
    /**
     * 业务类型
     */
    private String bizType;

    /**
     * 活动ID（无关联活动ID为-1）
     */
    private Long activityId;

    /**
     * 业务ID
     */
    private String bizId;

    /**
     * 业务内容
     */
    private String bizContext;

    /**
     * 业务ID模糊搜索，底层sql like, %需自行拼接，最左边为%会导致无法走索引，慎用
     */
    private String bizIdLike;

    /**
     * 业务内容模糊搜索，底层sql like, %需自行拼接，最左边为%会导致无法走索引，慎用
     */
    private String bizContextLike;

}
