package cn.com.duiba.quanyi.center.api.param.refund;

import java.util.Date;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 退款定时扫描任务分页查询参数
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class RefundScanTaskPageQueryParam extends PageQuery {

    /**
     * 业务类型
     */
    private Integer businessType;

    /**
     * 业务ID
     */
    private String businessId;

    /**
     * 任务状态
     */
    private Integer scanTaskStatus;

    /**
     * 失败文件路径
     */
    private String failFile;

    /**
     * 失败数量最小值
     */
    private Integer failCountMin;

    /**
     * 失败数量最大值
     */
    private Integer failCountMax;

    /**
     * 创建时间开始
     */
    private Date gmtCreateStart;

    /**
     * 创建时间结束
     */
    private Date gmtCreateEnd;

    /**
     * 修改时间开始
     */
    private Date gmtModifiedStart;

    /**
     * 修改时间结束
     */
    private Date gmtModifiedEnd;
}
