package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 活动支付卡类型
 *  储蓄卡，信用卡，不限制
 * @author lfh
 */

@Getter
@AllArgsConstructor
public enum ActivityPayCardTypeEnum {
    UNLIMITED(0, "不限制"),
    DEPOSIT_CARD(1, "储蓄卡"),
    CREDIT_CARD(2, "信用卡"),
    ;
    private final Integer type;
    private final String desc;

    /**
     * 根据type获取枚举
     * @param type
     * @return
     */
    public static ActivityPayCardTypeEnum getEnumByType(Integer type) {
        for (ActivityPayCardTypeEnum activityPayCardTypeEnum : ActivityPayCardTypeEnum.values()) {
            if (activityPayCardTypeEnum.getType().equals(type)) {
                return activityPayCardTypeEnum;
            }
        }
        return null;
    }
}
