package cn.com.duiba.quanyi.center.api.enums.settlement.receive;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/12/11 14:26
 */
@AllArgsConstructor
@Getter
public enum SettlementReceivedStatusEnum {
    // 状态：
    //待关联-自动关联-取消关联中-待关联（同意）/自动关联（拒绝）
    //待关联-批量关联-取消关联中-待关联（同意）/批量关联（拒绝）
    //待关联-关联中-已关联（同意）-取消关联中-待关联（同意）/已关联（同意）
    //待关联-关联中-待关联（拒绝）
    // 全部/待关联/关联中/撤销中/已关联/自动关联/批量关联
    TO_BE_ASSOCIATED(1, "待关联"),
    ASSOCIATING(2, "关联中"),
    ASSOCIATED(3, "已关联"),
    AUTO_ASSOCIATION(4, "自动关联"),
    CANCELLING(5, "撤销中"),
    BATCH_ASSOCIATION(6, "批量关联"),
    HISTORY_ASSOCIATION(7, "历史关联"),
    PREPAYMENT_ASSOCIATION(8, "预付款关联"),
    ;

    private final Integer status;

    private final String desc;

    private static final Map<Integer, SettlementReceivedStatusEnum> ENUM_MAP =
            Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SettlementReceivedStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据状态获取枚举
     * @param status 状态
     * @return 枚举
     */
    public static SettlementReceivedStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
