package cn.com.duiba.quanyi.center.api.param.demand;

import lombok.Data;

import java.io.Serializable;

/**
 * 需求占用批量操作参数
 *
 * @author xuzhigang
 * @date 2025-01-21
 */
@Data
public class DemandOccupyBatchParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 占用金额
     */
    private Long occupyAmount;

    /**
     * 结算金额（新增时使用，默认为0）
     */
    private Long settlementAmount;

    public DemandOccupyBatchParam() {
    }

    public DemandOccupyBatchParam(Long demandId, Long occupyAmount) {
        this.demandId = demandId;
        this.occupyAmount = occupyAmount;
        this.settlementAmount = 0L;
    }

    public DemandOccupyBatchParam(Long demandId, Long occupyAmount, Long settlementAmount) {
        this.demandId = demandId;
        this.occupyAmount = occupyAmount;
        this.settlementAmount = settlementAmount;
    }
} 