package cn.com.duiba.quanyi.center.api.param.contract;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 合同金额更新参数
 *
 * @author xuzhigang
 * @date 2025-1-3
 */
@Data
public class ContractAmountUpdateParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 减少的金额（正数表示减少，负数表示增加）
     */
    private Long decreaseAmount;

    /**
     * 修改时间（乐观锁版本控制）
     */
    private Date gmtModified;

    public ContractAmountUpdateParam() {}

    public ContractAmountUpdateParam(Long contractId, Long decreaseAmount, Date gmtModified) {
        this.contractId = contractId;
        this.decreaseAmount = decreaseAmount;
        this.gmtModified = gmtModified;
    }
} 