package cn.com.duiba.quanyi.center.api.dto.mall.goods;

import cn.com.duiba.quanyi.center.api.dto.activity.CouponExpireTypeDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 商品详情信息
 *
 * @author xuzhigang
 * @date 2024/5/26 11:32
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MallGoodsDetailDto extends MallSpuDto {
    private static final long serialVersionUID = 1063631926682746956L;

    /**
     * 最低划线价，单位分
     */
    private Long minMarketPrice;

    /**
     * 最高划线价，单位分
     */
    private Long maxMarketPrice;

    /**
     * 最低售卖价，单位分
     */
    private Long minSellPrice;

    /**
     * 最高售卖价，单位分
     */
    private Long maxSellPrice;

    /**
     * 最低兑换价，单位分
     */
    private Long minTakePrice;

    /**
     * 最高兑换价，单位分
     */
    private Long maxTakePrice;

    /**
     * 领取方式
     */
    private Integer grantType;

    /**
     * sku列表
     */
    private List<MallSkuDetailDto> skuList;

    /**
     * 短链领取
     */
    private CouponExpireTypeDto couponExpireTypeDto;
}
