package cn.com.duiba.quanyi.center.api.remoteservice.qy.bank.zgbank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bank.zgbank.ZgbankSettleRecordDto;
import cn.com.duiba.quanyi.center.api.param.bank.zgbank.ZgbankSettleRecordSearchParam;
import java.util.List;

/**
 * 中国银行对账记录表
 * @author kjj mybatis generator 
 * @date 2024-10-30
 */
@AdvancedFeignClient
public interface RemoteZgbankSettleRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 中国银行对账记录集合
     */
    List<ZgbankSettleRecordDto> selectPage(ZgbankSettleRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ZgbankSettleRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 中国银行对账记录
     */
    ZgbankSettleRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 中国银行对账记录
     * @return 执行结果
     */
    Long insert(ZgbankSettleRecordDto dto);

    /**
     * 更新
     * @param dto 中国银行对账记录
     * @return 影响行数
     */
    int update(ZgbankSettleRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 唯一键查询
     * @param settlementDt
     * @return
     */
    ZgbankSettleRecordDto selectByUk(String settlementDt);

    /**
     * 根据对账计划编号和结算单号查询
     * @param settlePlanNo
     * @param settlementNo
     * @return
     */
    ZgbankSettleRecordDto selectBySettlePlanNoAndSettlementNo(String settlePlanNo, String settlementNo);
}