package cn.com.duiba.quanyi.center.api.enums.mall;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 商城积分生效枚举 0-未生效 1-已生效 2-待匹配（预导入积分场景）
 *
 * @author wangguanhua
 */
@AllArgsConstructor
@Getter
public enum MallCreditsEffectiveEnum {

    /**
     * 未生效
     */
    NOT_EFFECTIVE(0, "未生效"),

    /**
     * 已生效
     */
    EFFECTIVE(1, "已生效"),
    ;

    private final Integer code;

    private final String desc;
}
