package cn.com.duiba.quanyi.center.api.param.boc.szbl;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 深圳中行活动便利仓基础请求DTO
 * @author cxw
 * @date 2025/01/20
 */
@Data
public class BocSzBlBaseRequest implements Serializable {

    /**
     * 秘钥密文 - 由发送方使用接收方公钥加密SM4秘钥得到
     */
    @NotBlank(message = "秘钥密文不能为空")
    private String cipherkey;

    /**
     * 数据密文 - 由发送方使用SM4秘钥加密数据明文得到
     */
    @NotBlank(message = "数据密文不能为空")
    private String ciphertext;

    /**
     * 数据签名 - 由发送方使用己方私钥加密数据明文得到
     */
    @NotBlank(message = "数据签名不能为空")
    private String sign;

    /**
     * 发送方企业code - 由行内下发(仅部分接口需要)
     */
    private String companyCode;
} 