package cn.com.duiba.quanyi.center.api.dto.project;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 项目与标准定制产品关联关系
 * @author mybatis generator 
 * @date 2025-06-11
 */
@Data
public class ProjectProductDto implements Serializable {
     
    private static final long serialVersionUID = 17496341063792078L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目id
     */
    private Long projectId;

    /**
     * 产品id
     */
    private Long productId;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品类型 1-标准产品 2-定制产品
     * @see cn.com.duiba.quanyi.center.api.enums.product.ProductTypeEnum
     */
    private Integer productType;

    /**
     * 基础价
     */
    private Long basePrice;

    /**
     * 内部价
     */
    private Long internalPrice;

    /**
     * 实际售价
     */
    private Long sellPrice;

    /**
     * 数量
     */
    private Integer quantity;
}