package cn.com.duiba.quanyi.center.api.enums;

import lombok.Getter;

/**
 * 退款扫描任务状态枚举
 *
 * @author yangyukang
 * @date 2025-01-21 15:30
 */
@Getter
public enum RefundScanTaskStatusEnum {

    /**
     * 待执行
     */
    PENDING(0, "待执行"),

    /**
     * 执行中
     */
    RUNNING(1, "执行中"),

    /**
     * 执行完成
     */
    COMPLETED(2, "执行完成");

    private final Integer status;
    private final String desc;

    RefundScanTaskStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    /**
     * 根据状态码获取枚举
     *
     * @param status 状态码
     * @return 枚举值
     */
    public static RefundScanTaskStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        for (RefundScanTaskStatusEnum statusEnum : values()) {
            if (statusEnum.getStatus().equals(status)) {
                return statusEnum;
            }
        }
        return null;
    }
}
