package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/4/22 11:03
 */
@AllArgsConstructor
@Getter
public enum ActivityPrizeDrawTypeEnum {
    PROBABILITY(1, "概率出奖"),
    DIRECT(2, "直接出奖"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, ActivityPrizeDrawTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityPrizeDrawTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static ActivityPrizeDrawTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
    
}
