package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/12/6 14:46
 */
@AllArgsConstructor
@Getter
public enum SettlementStatTaskTypeEnum {
    // 1-开票，2-发票红冲，3-发票移除，4-回款认领，5-回款取消认领
    INVOICED(1, "开票"),
    INVOICE_RED_OFFSET(2, "发票红冲"),
    REMOVED(3, "发票移除"),
    RECEIVED(4, "回款认领"),
    RECEIVED_CALLBACK(5, "回款取消认领"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    public boolean isInvoice() {
        return this.equals(INVOICED) || this.equals(INVOICE_RED_OFFSET) || this.equals(REMOVED);
    }
    
    private static final Map<Integer, SettlementStatTaskTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SettlementStatTaskTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static SettlementStatTaskTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
