package cn.com.duiba.quanyi.center.api.param.order;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Description 商品订单查询参数
 * @Author cuizhoujian
 * @Date 2025-04-13 20:18:55
 */
@Data
public class GoodsOrderStatusParam {
    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     */
    private Integer goodsBizType;

    /**
     * 商品库订单业务主键
     */
    private List<Long> goodsBizIds;

    /**
     * 订单状态
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 订单创建时间-开始
     */
    private Date beginTime;

    /**
     * 订单创建时间-结束
     */
    private Date endTime;
}
