package cn.com.duiba.quanyi.center.api.remoteservice.dayan;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.partner.PartnerDto;
import cn.com.duiba.quanyi.center.api.param.PartnerPageQueryParam;

import java.util.List;

/**
 * 大雁客户服务
 */
@AdvancedFeignClient
public interface RemoteDayanPartnerService {

    /**
     * 根据名称查询
     *
     * @param name 名称
     * @param limit 查询条数
     * @return 客户信息
     */
    List<PartnerDto> findByNameOrSubject(String name, int limit);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 客户信息
     */
    PartnerDto findById(Long id);

    /**
     * 分页查询-数量
     * @param param 参数
     * @return 总数
     */
    Integer selectCount(PartnerPageQueryParam param);

    /**
     * 分页查询
     * @param param 参数
     * @return 客户信息
     */
    List<PartnerDto> selectPage(PartnerPageQueryParam param);
}
