package cn.com.duiba.quanyi.center.api.dto.demand;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.dto.settlement.adjustment.SettlementAdjustmentRuleDto;
import lombok.Data;

/**
 * 需求商品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class DemandGoodsDto implements Serializable {

    private static final long serialVersionUID = 5300114912265510532L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 合同商品id
     */
    private Long contractGoodsId;

    /**
     * 项目商品ID
     */
    private Long projectGoodsId;

    /**
     * 采购商品类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.PurchaseSpuTypeEnum
     */
    private Integer purchaseSpuType;

    /**
     * 采购面额类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.PurchaseSpuAmountTypeEnum
     */
    private Integer purchaseSpuAmountType;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 商品spuId
     */
    private Long spuId;

    /**
     * 商品规格Id
     */
    private Long skuId;

    /**
     * 面额，单位分
     */
    private Long amount;

    /**
     * 面额类型：1-固定，2-不固定
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 不固定面额：最小面额，单位分
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大面额，单位分
     */
    private Long rangeMaxAmount;

    /**
     * 审核状态
     *
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum
     */
    private Integer approvalStatus;

    /**
     * 采购状态
     *
     * @see cn.com.duiba.quanyi.center.api.enums.demand.PurchaseStatusEnum
     */
    private Integer purchaseStatus;

    /**
     * 商品状态，0-未启用，1-已启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer goodsStatus;

    /**
     * 审批流主键
     */
    private Long workflowInstanceId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 备注
     */
    private String remark;

    /**
     * 需求商品数量
     */
    private Long quantity;

    /**
     * 退款结算天数
     */
    private Integer settlementDeadlineDays;

    /**
     * 退款结算类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.SettlementDeadlineTypeEnum
     */
    private Integer settlementDeadlineType;

    /**
     * 更新商品数量操作人id
     */
    private Long updateQuantityOperatorId;

    /**
     * 更新商品数量操作人名称
     */
    private String updateQuantityOperatorName;

    /**
     * 消耗预算，单位分
     */
    private Long consumeBudget;

    /**
     * 占用合同金额，单位分
     */
    private Long occupyContractAmount;

    /**
     * 消耗金额，单位分
     */
    private Long consumeAmount;

    /**
     * 消耗预算（计算服务费），单位分
     */
    private Long consumeBudgetWithFee;

    /**
     * 调整规则
     */
    private SettlementAdjustmentRuleDto adjustmentRule;
}

