package cn.com.duiba.quanyi.center.api.dto.payment;

import java.io.Serializable;
import java.util.Date;

import cn.com.duiba.quanyi.center.api.enums.payment.PaymentPrepaymentRefundMethodEnum;
import lombok.Data;

/**
 * 打款申请-预付款退款
 * @author mybatis generator
 * @date 2025-08-28
 */
@Data
public class PaymentInfoPrepaymentDto implements Serializable {

    private static final long serialVersionUID = 1756361311550465L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 付款ID
     */
    private Long paymentId;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 退款方式：1-关联负票，2-不关联负票
     * @see PaymentPrepaymentRefundMethodEnum
     */
    private Integer refundMethod;

    /**
     * 打款日期：日期，必填
     */
    private Date paymentDate;
}
